# DX makefile
# TC component
#

COMP_NAME = $(TC_ID)

#id's of the components this component depends on
$(COMP_NAME)_DEPEND_ON_APIS := $(TM_ID) 

#id's of the components whose objects are used by this component
$(COMP_NAME)_USE_OBJ_IDS := 

#paths of this component API include directories
$(COMP_NAME)_API_INCL_PATH := \
	$(BASE_PATH)QAT_LibTomCrypt/TCLib_API/

#paths of the internal include directories
$(COMP_NAME)_INTERNAL_INCL_PATH := \
	$(BASE_PATH)QAT_LibTomCrypt/TCLib_TomCrypt/src/headers

#global flags for this component
$(COMP_NAME)_CCFLAGS := -DLTC_SOURCE -DLTM_DESC -DUSE_LTM -D_MBCS -DIGNORE_SPEED -DPKCS_1
#project-specific flags for this component should be added to $($(COMP_NAME)_SPECIFIC_CCFLAGS) outside of this makefile

#the objects names without path or extension
$(COMP_NAME)_OBJ_NAMES := \
	aes anubis blowfish \
	cast5 des kasumi khazad kseed \
	multi2 noekeon rc2 rc5 rc6 \
	safer saferp skipjack twofish \
	xtea ccm_memory ccm_test eax_addheader \
	eax_decrypt eax_decrypt_verify_memory eax_done eax_encrypt eax_encrypt_authenticate_memory \
	eax_init eax_test gcm_add_aad gcm_add_iv gcm_done \
	gcm_gf_mult gcm_init gcm_memory gcm_mult_h gcm_process \
	gcm_reset gcm_test ocb_decrypt ocb_decrypt_verify_memory ocb_done_decrypt \
	ocb_done_encrypt ocb_encrypt ocb_encrypt_authenticate_memory ocb_init ocb_ntz \
	ocb_shift_xor ocb_test s_ocb_done chc hash_file \
	hash_filehandle hash_memory hash_memory_multi md2 md4 \
	md5 rmd128 rmd160 rmd256 rmd320 \
	sha1 sha256 sha512 \
	tiger whirl f9_done f9_file \
	f9_init f9_memory f9_memory_multi f9_process f9_test \
	hmac_done hmac_file hmac_init hmac_memory hmac_memory_multi \
	hmac_process hmac_test omac_done omac_file omac_init \
	omac_memory omac_memory_multi omac_process omac_test pelican \
	pelican_memory pelican_test pmac_done pmac_file pmac_init \
	pmac_memory pmac_memory_multi pmac_ntz pmac_process pmac_shift_xor \
	pmac_test xcbc_done xcbc_file xcbc_init xcbc_memory \
	xcbc_memory_multi xcbc_process xcbc_test ltc_ecc_fp_mulmod gmp_desc \
	ltm_desc multi rand_prime tfm_desc base64_decode \
	base64_encode burn_stack crypt crypt_argchk crypt_cipher_descriptor \
	crypt_cipher_is_valid crypt_find_cipher crypt_find_cipher_any crypt_find_cipher_id crypt_find_hash \
	crypt_find_hash_any crypt_find_hash_id crypt_find_hash_oid crypt_find_prng crypt_fsa \
	crypt_hash_descriptor crypt_hash_is_valid crypt_ltc_mp_descriptor crypt_prng_descriptor crypt_prng_is_valid \
	crypt_register_cipher crypt_register_hash crypt_register_prng crypt_unregister_cipher crypt_unregister_hash \
	crypt_unregister_prng error_to_string pkcs_5_1 pkcs_5_2 zeromem \
	cbc_decrypt cbc_done cbc_encrypt cbc_getiv cbc_setiv \
	cbc_start cfb_decrypt cfb_done cfb_encrypt cfb_getiv \
	cfb_setiv cfb_start ctr_decrypt ctr_done ctr_encrypt \
	ctr_getiv ctr_setiv ctr_start ctr_test ecb_decrypt \
	ecb_done ecb_encrypt ecb_start f8_decrypt f8_done \
	f8_encrypt f8_getiv f8_setiv f8_start f8_test_mode \
	lrw_decrypt lrw_done lrw_encrypt lrw_getiv lrw_process \
	lrw_setiv lrw_start lrw_test ofb_decrypt ofb_done \
	ofb_encrypt ofb_getiv ofb_setiv ofb_start xts_decrypt \
	xts_done xts_encrypt xts_init xts_mult_x xts_test \
	der_decode_bit_string der_encode_bit_string der_length_bit_string der_decode_boolean der_encode_boolean \
	der_length_boolean der_decode_choice der_decode_ia5_string der_encode_ia5_string der_length_ia5_string \
	der_decode_integer der_encode_integer der_length_integer der_decode_object_identifier der_encode_object_identifier \
	der_length_object_identifier der_decode_octet_string der_encode_octet_string der_length_octet_string der_decode_printable_string \
	der_encode_printable_string der_length_printable_string der_decode_sequence_ex der_decode_sequence_flexi der_decode_sequence_multi \
	der_encode_sequence_ex der_encode_sequence_multi der_length_sequence der_sequence_free der_encode_set \
	der_encode_setof der_decode_short_integer der_encode_short_integer der_length_short_integer der_decode_utctime \
	der_encode_utctime der_length_utctime der_decode_utf8_string der_encode_utf8_string der_length_utf8_string \
	dsa_decrypt_key dsa_encrypt_key dsa_export dsa_free dsa_import \
	dsa_make_key dsa_shared_secret dsa_sign_hash dsa_verify_hash dsa_verify_key \
	ecc ecc_ansi_x963_export ecc_ansi_x963_import ecc_decrypt_key ecc_encrypt_key \
	ecc_export ecc_free ecc_get_size ecc_import ecc_make_key \
	ecc_shared_secret ecc_sign_hash ecc_sizes ecc_test ecc_verify_hash \
	ltc_ecc_is_valid_idx ltc_ecc_map ltc_ecc_mul2add ltc_ecc_mulmod ltc_ecc_mulmod_timing \
	ltc_ecc_points ltc_ecc_projective_add_point ltc_ecc_projective_dbl_point katja_decrypt_key katja_encrypt_key \
	katja_export katja_exptmod katja_free katja_import katja_make_key \
	pkcs_1_i2osp pkcs_1_mgf1 pkcs_1_oaep_decode pkcs_1_oaep_encode pkcs_1_os2ip \
	pkcs_1_pss_decode pkcs_1_pss_encode pkcs_1_v15_es_decode pkcs_1_v15_es_encode pkcs_1_v15_sa_decode \
	pkcs_1_v15_sa_encode pkcs_1_v1_5_decode pkcs_1_v1_5_encode rsa_decrypt_key rsa_encrypt_key \
	rsa_export rsa_exptmod rsa_free rsa_import rsa_make_key \
	rsa_sign_hash rsa_v15_decrypt_key rsa_v15_encrypt_key rsa_v15_sign_hash rsa_v15_verify_hash \
	rsa_verify_hash fortuna rc4 rng_get_bytes rng_make_prng \
	sober128 sprng yarrow 

$(COMP_NAME)_MAIN_OBJ_NAMES := \
	

#Use the above specific settings for building the components properties with the standard rules:
include $(MF_PATH)DX_STD_RULES.inc

##  OBJECT RULES - ADD RULES FOR NEW SOURCE FILES
#   make sure to add obj_name to the above list: $(COMP_NAME)_OBJS
#   this is the template for rules:
#$(OUT_OBJ_PATH)<<OBJ_NAME>>.$(OBJEXT): $(HOST_PATH)<<SOURCE_PATH>>
#	$(TC_CC_CMD) $< $(CCFLAG_OUTPUT) $@
$(OUT_OBJ_PATH)encrypt.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomCrypt/demos/encrypt.c
	$(TC_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)hashsum.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomCrypt/demos/hashsum.c
	$(TC_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)multi.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomCrypt/demos/multi.c
	$(TC_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)small.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomCrypt/demos/small.c
	$(TC_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)test.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomCrypt/demos/test.c
	$(TC_CC_CMD) $< $(CCFLAG_OUTPUT) $@

#~ $(OUT_OBJ_PATH)timing.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomCrypt/demos/timing.c
	#~ $(TC_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)tv_gen.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomCrypt/demos/tv_gen.c
	$(TC_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)x86_prof.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomCrypt/demos/x86_prof.c
	$(TC_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)aes.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomCrypt/src/ciphers/aes/aes.c
	$(TC_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)anubis.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomCrypt/src/ciphers/anubis.c
	$(TC_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)blowfish.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomCrypt/src/ciphers/blowfish.c
	$(TC_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)cast5.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomCrypt/src/ciphers/cast5.c
	$(TC_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)des.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomCrypt/src/ciphers/des.c
	$(TC_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)kasumi.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomCrypt/src/ciphers/kasumi.c
	$(TC_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)khazad.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomCrypt/src/ciphers/khazad.c
	$(TC_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)kseed.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomCrypt/src/ciphers/kseed.c
	$(TC_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)multi2.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomCrypt/src/ciphers/multi2.c
	$(TC_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)noekeon.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomCrypt/src/ciphers/noekeon.c
	$(TC_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)rc2.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomCrypt/src/ciphers/rc2.c
	$(TC_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)rc5.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomCrypt/src/ciphers/rc5.c
	$(TC_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)rc6.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomCrypt/src/ciphers/rc6.c
	$(TC_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)safer.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomCrypt/src/ciphers/safer/safer.c
	$(TC_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)saferp.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomCrypt/src/ciphers/safer/saferp.c
	$(TC_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)skipjack.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomCrypt/src/ciphers/skipjack.c
	$(TC_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)twofish.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomCrypt/src/ciphers/twofish/twofish.c
	$(TC_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)xtea.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomCrypt/src/ciphers/xtea.c
	$(TC_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)ccm_memory.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomCrypt/src/encauth/ccm/ccm_memory.c
	$(TC_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)ccm_test.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomCrypt/src/encauth/ccm/ccm_test.c
	$(TC_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)eax_addheader.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomCrypt/src/encauth/eax/eax_addheader.c
	$(TC_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)eax_decrypt.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomCrypt/src/encauth/eax/eax_decrypt.c
	$(TC_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)eax_decrypt_verify_memory.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomCrypt/src/encauth/eax/eax_decrypt_verify_memory.c
	$(TC_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)eax_done.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomCrypt/src/encauth/eax/eax_done.c
	$(TC_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)eax_encrypt.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomCrypt/src/encauth/eax/eax_encrypt.c
	$(TC_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)eax_encrypt_authenticate_memory.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomCrypt/src/encauth/eax/eax_encrypt_authenticate_memory.c
	$(TC_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)eax_init.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomCrypt/src/encauth/eax/eax_init.c
	$(TC_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)eax_test.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomCrypt/src/encauth/eax/eax_test.c
	$(TC_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)gcm_add_aad.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomCrypt/src/encauth/gcm/gcm_add_aad.c
	$(TC_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)gcm_add_iv.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomCrypt/src/encauth/gcm/gcm_add_iv.c
	$(TC_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)gcm_done.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomCrypt/src/encauth/gcm/gcm_done.c
	$(TC_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)gcm_gf_mult.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomCrypt/src/encauth/gcm/gcm_gf_mult.c
	$(TC_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)gcm_init.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomCrypt/src/encauth/gcm/gcm_init.c
	$(TC_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)gcm_memory.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomCrypt/src/encauth/gcm/gcm_memory.c
	$(TC_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)gcm_mult_h.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomCrypt/src/encauth/gcm/gcm_mult_h.c
	$(TC_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)gcm_process.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomCrypt/src/encauth/gcm/gcm_process.c
	$(TC_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)gcm_reset.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomCrypt/src/encauth/gcm/gcm_reset.c
	$(TC_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)gcm_test.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomCrypt/src/encauth/gcm/gcm_test.c
	$(TC_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)ocb_decrypt.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomCrypt/src/encauth/ocb/ocb_decrypt.c
	$(TC_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)ocb_decrypt_verify_memory.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomCrypt/src/encauth/ocb/ocb_decrypt_verify_memory.c
	$(TC_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)ocb_done_decrypt.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomCrypt/src/encauth/ocb/ocb_done_decrypt.c
	$(TC_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)ocb_done_encrypt.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomCrypt/src/encauth/ocb/ocb_done_encrypt.c
	$(TC_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)ocb_encrypt.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomCrypt/src/encauth/ocb/ocb_encrypt.c
	$(TC_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)ocb_encrypt_authenticate_memory.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomCrypt/src/encauth/ocb/ocb_encrypt_authenticate_memory.c
	$(TC_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)ocb_init.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomCrypt/src/encauth/ocb/ocb_init.c
	$(TC_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)ocb_ntz.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomCrypt/src/encauth/ocb/ocb_ntz.c
	$(TC_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)ocb_shift_xor.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomCrypt/src/encauth/ocb/ocb_shift_xor.c
	$(TC_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)ocb_test.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomCrypt/src/encauth/ocb/ocb_test.c
	$(TC_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)s_ocb_done.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomCrypt/src/encauth/ocb/s_ocb_done.c
	$(TC_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)chc.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomCrypt/src/hashes/chc/chc.c
	$(TC_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)hash_file.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomCrypt/src/hashes/helper/hash_file.c
	$(TC_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)hash_filehandle.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomCrypt/src/hashes/helper/hash_filehandle.c
	$(TC_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)hash_memory.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomCrypt/src/hashes/helper/hash_memory.c
	$(TC_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)hash_memory_multi.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomCrypt/src/hashes/helper/hash_memory_multi.c
	$(TC_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)md2.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomCrypt/src/hashes/md2.c
	$(TC_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)md4.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomCrypt/src/hashes/md4.c
	$(TC_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)md5.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomCrypt/src/hashes/md5.c
	$(TC_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)rmd128.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomCrypt/src/hashes/rmd128.c
	$(TC_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)rmd160.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomCrypt/src/hashes/rmd160.c
	$(TC_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)rmd256.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomCrypt/src/hashes/rmd256.c
	$(TC_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)rmd320.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomCrypt/src/hashes/rmd320.c
	$(TC_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)sha1.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomCrypt/src/hashes/sha1.c
	$(TC_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)sha256.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomCrypt/src/hashes/sha2/sha256.c
	$(TC_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)sha512.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomCrypt/src/hashes/sha2/sha512.c
	$(TC_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)tiger.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomCrypt/src/hashes/tiger.c
	$(TC_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)whirl.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomCrypt/src/hashes/whirl/whirl.c
	$(TC_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)f9_done.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomCrypt/src/mac/f9/f9_done.c
	$(TC_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)f9_file.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomCrypt/src/mac/f9/f9_file.c
	$(TC_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)f9_init.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomCrypt/src/mac/f9/f9_init.c
	$(TC_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)f9_memory.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomCrypt/src/mac/f9/f9_memory.c
	$(TC_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)f9_memory_multi.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomCrypt/src/mac/f9/f9_memory_multi.c
	$(TC_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)f9_process.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomCrypt/src/mac/f9/f9_process.c
	$(TC_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)f9_test.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomCrypt/src/mac/f9/f9_test.c
	$(TC_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)hmac_done.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomCrypt/src/mac/hmac/hmac_done.c
	$(TC_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)hmac_file.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomCrypt/src/mac/hmac/hmac_file.c
	$(TC_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)hmac_init.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomCrypt/src/mac/hmac/hmac_init.c
	$(TC_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)hmac_memory.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomCrypt/src/mac/hmac/hmac_memory.c
	$(TC_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)hmac_memory_multi.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomCrypt/src/mac/hmac/hmac_memory_multi.c
	$(TC_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)hmac_process.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomCrypt/src/mac/hmac/hmac_process.c
	$(TC_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)hmac_test.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomCrypt/src/mac/hmac/hmac_test.c
	$(TC_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)omac_done.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomCrypt/src/mac/omac/omac_done.c
	$(TC_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)omac_file.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomCrypt/src/mac/omac/omac_file.c
	$(TC_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)omac_init.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomCrypt/src/mac/omac/omac_init.c
	$(TC_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)omac_memory.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomCrypt/src/mac/omac/omac_memory.c
	$(TC_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)omac_memory_multi.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomCrypt/src/mac/omac/omac_memory_multi.c
	$(TC_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)omac_process.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomCrypt/src/mac/omac/omac_process.c
	$(TC_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)omac_test.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomCrypt/src/mac/omac/omac_test.c
	$(TC_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)pelican.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomCrypt/src/mac/pelican/pelican.c
	$(TC_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)pelican_memory.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomCrypt/src/mac/pelican/pelican_memory.c
	$(TC_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)pelican_test.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomCrypt/src/mac/pelican/pelican_test.c
	$(TC_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)pmac_done.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomCrypt/src/mac/pmac/pmac_done.c
	$(TC_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)pmac_file.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomCrypt/src/mac/pmac/pmac_file.c
	$(TC_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)pmac_init.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomCrypt/src/mac/pmac/pmac_init.c
	$(TC_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)pmac_memory.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomCrypt/src/mac/pmac/pmac_memory.c
	$(TC_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)pmac_memory_multi.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomCrypt/src/mac/pmac/pmac_memory_multi.c
	$(TC_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)pmac_ntz.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomCrypt/src/mac/pmac/pmac_ntz.c
	$(TC_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)pmac_process.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomCrypt/src/mac/pmac/pmac_process.c
	$(TC_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)pmac_shift_xor.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomCrypt/src/mac/pmac/pmac_shift_xor.c
	$(TC_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)pmac_test.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomCrypt/src/mac/pmac/pmac_test.c
	$(TC_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)xcbc_done.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomCrypt/src/mac/xcbc/xcbc_done.c
	$(TC_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)xcbc_file.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomCrypt/src/mac/xcbc/xcbc_file.c
	$(TC_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)xcbc_init.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomCrypt/src/mac/xcbc/xcbc_init.c
	$(TC_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)xcbc_memory.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomCrypt/src/mac/xcbc/xcbc_memory.c
	$(TC_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)xcbc_memory_multi.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomCrypt/src/mac/xcbc/xcbc_memory_multi.c
	$(TC_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)xcbc_process.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomCrypt/src/mac/xcbc/xcbc_process.c
	$(TC_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)xcbc_test.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomCrypt/src/mac/xcbc/xcbc_test.c
	$(TC_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)ltc_ecc_fp_mulmod.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomCrypt/src/math/fp/ltc_ecc_fp_mulmod.c
	$(TC_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)gmp_desc.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomCrypt/src/math/gmp_desc.c
	$(TC_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)ltm_desc.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomCrypt/src/math/ltm_desc.c
	$(TC_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)multi.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomCrypt/src/math/multi.c
	$(TC_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)rand_prime.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomCrypt/src/math/rand_prime.c
	$(TC_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)tfm_desc.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomCrypt/src/math/tfm_desc.c
	$(TC_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)base64_decode.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomCrypt/src/misc/base64/base64_decode.c
	$(TC_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)base64_encode.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomCrypt/src/misc/base64/base64_encode.c
	$(TC_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)burn_stack.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomCrypt/src/misc/burn_stack.c
	$(TC_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)crypt.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomCrypt/src/misc/crypt/crypt.c
	$(TC_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)crypt_argchk.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomCrypt/src/misc/crypt/crypt_argchk.c
	$(TC_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)crypt_cipher_descriptor.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomCrypt/src/misc/crypt/crypt_cipher_descriptor.c
	$(TC_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)crypt_cipher_is_valid.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomCrypt/src/misc/crypt/crypt_cipher_is_valid.c
	$(TC_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)crypt_find_cipher.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomCrypt/src/misc/crypt/crypt_find_cipher.c
	$(TC_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)crypt_find_cipher_any.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomCrypt/src/misc/crypt/crypt_find_cipher_any.c
	$(TC_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)crypt_find_cipher_id.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomCrypt/src/misc/crypt/crypt_find_cipher_id.c
	$(TC_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)crypt_find_hash.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomCrypt/src/misc/crypt/crypt_find_hash.c
	$(TC_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)crypt_find_hash_any.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomCrypt/src/misc/crypt/crypt_find_hash_any.c
	$(TC_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)crypt_find_hash_id.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomCrypt/src/misc/crypt/crypt_find_hash_id.c
	$(TC_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)crypt_find_hash_oid.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomCrypt/src/misc/crypt/crypt_find_hash_oid.c
	$(TC_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)crypt_find_prng.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomCrypt/src/misc/crypt/crypt_find_prng.c
	$(TC_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)crypt_fsa.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomCrypt/src/misc/crypt/crypt_fsa.c
	$(TC_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)crypt_hash_descriptor.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomCrypt/src/misc/crypt/crypt_hash_descriptor.c
	$(TC_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)crypt_hash_is_valid.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomCrypt/src/misc/crypt/crypt_hash_is_valid.c
	$(TC_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)crypt_ltc_mp_descriptor.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomCrypt/src/misc/crypt/crypt_ltc_mp_descriptor.c
	$(TC_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)crypt_prng_descriptor.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomCrypt/src/misc/crypt/crypt_prng_descriptor.c
	$(TC_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)crypt_prng_is_valid.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomCrypt/src/misc/crypt/crypt_prng_is_valid.c
	$(TC_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)crypt_register_cipher.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomCrypt/src/misc/crypt/crypt_register_cipher.c
	$(TC_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)crypt_register_hash.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomCrypt/src/misc/crypt/crypt_register_hash.c
	$(TC_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)crypt_register_prng.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomCrypt/src/misc/crypt/crypt_register_prng.c
	$(TC_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)crypt_unregister_cipher.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomCrypt/src/misc/crypt/crypt_unregister_cipher.c
	$(TC_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)crypt_unregister_hash.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomCrypt/src/misc/crypt/crypt_unregister_hash.c
	$(TC_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)crypt_unregister_prng.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomCrypt/src/misc/crypt/crypt_unregister_prng.c
	$(TC_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)error_to_string.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomCrypt/src/misc/error_to_string.c
	$(TC_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)pkcs_5_1.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomCrypt/src/misc/pkcs5/pkcs_5_1.c
	$(TC_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)pkcs_5_2.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomCrypt/src/misc/pkcs5/pkcs_5_2.c
	$(TC_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)zeromem.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomCrypt/src/misc/zeromem.c
	$(TC_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)cbc_decrypt.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomCrypt/src/modes/cbc/cbc_decrypt.c
	$(TC_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)cbc_done.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomCrypt/src/modes/cbc/cbc_done.c
	$(TC_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)cbc_encrypt.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomCrypt/src/modes/cbc/cbc_encrypt.c
	$(TC_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)cbc_getiv.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomCrypt/src/modes/cbc/cbc_getiv.c
	$(TC_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)cbc_setiv.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomCrypt/src/modes/cbc/cbc_setiv.c
	$(TC_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)cbc_start.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomCrypt/src/modes/cbc/cbc_start.c
	$(TC_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)cfb_decrypt.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomCrypt/src/modes/cfb/cfb_decrypt.c
	$(TC_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)cfb_done.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomCrypt/src/modes/cfb/cfb_done.c
	$(TC_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)cfb_encrypt.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomCrypt/src/modes/cfb/cfb_encrypt.c
	$(TC_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)cfb_getiv.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomCrypt/src/modes/cfb/cfb_getiv.c
	$(TC_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)cfb_setiv.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomCrypt/src/modes/cfb/cfb_setiv.c
	$(TC_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)cfb_start.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomCrypt/src/modes/cfb/cfb_start.c
	$(TC_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)ctr_decrypt.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomCrypt/src/modes/ctr/ctr_decrypt.c
	$(TC_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)ctr_done.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomCrypt/src/modes/ctr/ctr_done.c
	$(TC_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)ctr_encrypt.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomCrypt/src/modes/ctr/ctr_encrypt.c
	$(TC_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)ctr_getiv.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomCrypt/src/modes/ctr/ctr_getiv.c
	$(TC_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)ctr_setiv.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomCrypt/src/modes/ctr/ctr_setiv.c
	$(TC_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)ctr_start.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomCrypt/src/modes/ctr/ctr_start.c
	$(TC_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)ctr_test.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomCrypt/src/modes/ctr/ctr_test.c
	$(TC_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)ecb_decrypt.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomCrypt/src/modes/ecb/ecb_decrypt.c
	$(TC_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)ecb_done.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomCrypt/src/modes/ecb/ecb_done.c
	$(TC_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)ecb_encrypt.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomCrypt/src/modes/ecb/ecb_encrypt.c
	$(TC_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)ecb_start.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomCrypt/src/modes/ecb/ecb_start.c
	$(TC_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)f8_decrypt.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomCrypt/src/modes/f8/f8_decrypt.c
	$(TC_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)f8_done.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomCrypt/src/modes/f8/f8_done.c
	$(TC_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)f8_encrypt.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomCrypt/src/modes/f8/f8_encrypt.c
	$(TC_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)f8_getiv.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomCrypt/src/modes/f8/f8_getiv.c
	$(TC_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)f8_setiv.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomCrypt/src/modes/f8/f8_setiv.c
	$(TC_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)f8_start.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomCrypt/src/modes/f8/f8_start.c
	$(TC_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)f8_test_mode.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomCrypt/src/modes/f8/f8_test_mode.c
	$(TC_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)lrw_decrypt.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomCrypt/src/modes/lrw/lrw_decrypt.c
	$(TC_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)lrw_done.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomCrypt/src/modes/lrw/lrw_done.c
	$(TC_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)lrw_encrypt.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomCrypt/src/modes/lrw/lrw_encrypt.c
	$(TC_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)lrw_getiv.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomCrypt/src/modes/lrw/lrw_getiv.c
	$(TC_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)lrw_process.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomCrypt/src/modes/lrw/lrw_process.c
	$(TC_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)lrw_setiv.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomCrypt/src/modes/lrw/lrw_setiv.c
	$(TC_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)lrw_start.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomCrypt/src/modes/lrw/lrw_start.c
	$(TC_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)lrw_test.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomCrypt/src/modes/lrw/lrw_test.c
	$(TC_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)ofb_decrypt.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomCrypt/src/modes/ofb/ofb_decrypt.c
	$(TC_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)ofb_done.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomCrypt/src/modes/ofb/ofb_done.c
	$(TC_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)ofb_encrypt.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomCrypt/src/modes/ofb/ofb_encrypt.c
	$(TC_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)ofb_getiv.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomCrypt/src/modes/ofb/ofb_getiv.c
	$(TC_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)ofb_setiv.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomCrypt/src/modes/ofb/ofb_setiv.c
	$(TC_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)ofb_start.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomCrypt/src/modes/ofb/ofb_start.c
	$(TC_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)xts_decrypt.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomCrypt/src/modes/xts/xts_decrypt.c
	$(TC_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)xts_done.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomCrypt/src/modes/xts/xts_done.c
	$(TC_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)xts_encrypt.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomCrypt/src/modes/xts/xts_encrypt.c
	$(TC_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)xts_init.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomCrypt/src/modes/xts/xts_init.c
	$(TC_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)xts_mult_x.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomCrypt/src/modes/xts/xts_mult_x.c
	$(TC_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)xts_test.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomCrypt/src/modes/xts/xts_test.c
	$(TC_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)der_decode_bit_string.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomCrypt/src/pk/asn1/der/bit/der_decode_bit_string.c
	$(TC_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)der_encode_bit_string.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomCrypt/src/pk/asn1/der/bit/der_encode_bit_string.c
	$(TC_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)der_length_bit_string.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomCrypt/src/pk/asn1/der/bit/der_length_bit_string.c
	$(TC_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)der_decode_boolean.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomCrypt/src/pk/asn1/der/boolean/der_decode_boolean.c
	$(TC_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)der_encode_boolean.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomCrypt/src/pk/asn1/der/boolean/der_encode_boolean.c
	$(TC_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)der_length_boolean.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomCrypt/src/pk/asn1/der/boolean/der_length_boolean.c
	$(TC_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)der_decode_choice.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomCrypt/src/pk/asn1/der/choice/der_decode_choice.c
	$(TC_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)der_decode_ia5_string.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomCrypt/src/pk/asn1/der/ia5/der_decode_ia5_string.c
	$(TC_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)der_encode_ia5_string.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomCrypt/src/pk/asn1/der/ia5/der_encode_ia5_string.c
	$(TC_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)der_length_ia5_string.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomCrypt/src/pk/asn1/der/ia5/der_length_ia5_string.c
	$(TC_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)der_decode_integer.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomCrypt/src/pk/asn1/der/integer/der_decode_integer.c
	$(TC_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)der_encode_integer.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomCrypt/src/pk/asn1/der/integer/der_encode_integer.c
	$(TC_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)der_length_integer.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomCrypt/src/pk/asn1/der/integer/der_length_integer.c
	$(TC_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)der_decode_object_identifier.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomCrypt/src/pk/asn1/der/object_identifier/der_decode_object_identifier.c
	$(TC_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)der_encode_object_identifier.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomCrypt/src/pk/asn1/der/object_identifier/der_encode_object_identifier.c
	$(TC_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)der_length_object_identifier.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomCrypt/src/pk/asn1/der/object_identifier/der_length_object_identifier.c
	$(TC_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)der_decode_octet_string.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomCrypt/src/pk/asn1/der/octet/der_decode_octet_string.c
	$(TC_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)der_encode_octet_string.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomCrypt/src/pk/asn1/der/octet/der_encode_octet_string.c
	$(TC_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)der_length_octet_string.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomCrypt/src/pk/asn1/der/octet/der_length_octet_string.c
	$(TC_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)der_decode_printable_string.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomCrypt/src/pk/asn1/der/printable_string/der_decode_printable_string.c
	$(TC_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)der_encode_printable_string.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomCrypt/src/pk/asn1/der/printable_string/der_encode_printable_string.c
	$(TC_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)der_length_printable_string.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomCrypt/src/pk/asn1/der/printable_string/der_length_printable_string.c
	$(TC_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)der_decode_sequence_ex.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomCrypt/src/pk/asn1/der/sequence/der_decode_sequence_ex.c
	$(TC_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)der_decode_sequence_flexi.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomCrypt/src/pk/asn1/der/sequence/der_decode_sequence_flexi.c
	$(TC_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)der_decode_sequence_multi.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomCrypt/src/pk/asn1/der/sequence/der_decode_sequence_multi.c
	$(TC_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)der_encode_sequence_ex.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomCrypt/src/pk/asn1/der/sequence/der_encode_sequence_ex.c
	$(TC_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)der_encode_sequence_multi.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomCrypt/src/pk/asn1/der/sequence/der_encode_sequence_multi.c
	$(TC_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)der_length_sequence.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomCrypt/src/pk/asn1/der/sequence/der_length_sequence.c
	$(TC_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)der_sequence_free.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomCrypt/src/pk/asn1/der/sequence/der_sequence_free.c
	$(TC_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)der_encode_set.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomCrypt/src/pk/asn1/der/set/der_encode_set.c
	$(TC_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)der_encode_setof.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomCrypt/src/pk/asn1/der/set/der_encode_setof.c
	$(TC_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)der_decode_short_integer.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomCrypt/src/pk/asn1/der/short_integer/der_decode_short_integer.c
	$(TC_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)der_encode_short_integer.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomCrypt/src/pk/asn1/der/short_integer/der_encode_short_integer.c
	$(TC_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)der_length_short_integer.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomCrypt/src/pk/asn1/der/short_integer/der_length_short_integer.c
	$(TC_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)der_decode_utctime.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomCrypt/src/pk/asn1/der/utctime/der_decode_utctime.c
	$(TC_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)der_encode_utctime.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomCrypt/src/pk/asn1/der/utctime/der_encode_utctime.c
	$(TC_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)der_length_utctime.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomCrypt/src/pk/asn1/der/utctime/der_length_utctime.c
	$(TC_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)der_decode_utf8_string.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomCrypt/src/pk/asn1/der/utf8/der_decode_utf8_string.c
	$(TC_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)der_encode_utf8_string.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomCrypt/src/pk/asn1/der/utf8/der_encode_utf8_string.c
	$(TC_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)der_length_utf8_string.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomCrypt/src/pk/asn1/der/utf8/der_length_utf8_string.c
	$(TC_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)dsa_decrypt_key.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomCrypt/src/pk/dsa/dsa_decrypt_key.c
	$(TC_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)dsa_encrypt_key.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomCrypt/src/pk/dsa/dsa_encrypt_key.c
	$(TC_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)dsa_export.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomCrypt/src/pk/dsa/dsa_export.c
	$(TC_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)dsa_free.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomCrypt/src/pk/dsa/dsa_free.c
	$(TC_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)dsa_import.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomCrypt/src/pk/dsa/dsa_import.c
	$(TC_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)dsa_make_key.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomCrypt/src/pk/dsa/dsa_make_key.c
	$(TC_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)dsa_shared_secret.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomCrypt/src/pk/dsa/dsa_shared_secret.c
	$(TC_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)dsa_sign_hash.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomCrypt/src/pk/dsa/dsa_sign_hash.c
	$(TC_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)dsa_verify_hash.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomCrypt/src/pk/dsa/dsa_verify_hash.c
	$(TC_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)dsa_verify_key.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomCrypt/src/pk/dsa/dsa_verify_key.c
	$(TC_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)ecc.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomCrypt/src/pk/ecc/ecc.c
	$(TC_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)ecc_ansi_x963_export.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomCrypt/src/pk/ecc/ecc_ansi_x963_export.c
	$(TC_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)ecc_ansi_x963_import.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomCrypt/src/pk/ecc/ecc_ansi_x963_import.c
	$(TC_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)ecc_decrypt_key.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomCrypt/src/pk/ecc/ecc_decrypt_key.c
	$(TC_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)ecc_encrypt_key.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomCrypt/src/pk/ecc/ecc_encrypt_key.c
	$(TC_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)ecc_export.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomCrypt/src/pk/ecc/ecc_export.c
	$(TC_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)ecc_free.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomCrypt/src/pk/ecc/ecc_free.c
	$(TC_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)ecc_get_size.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomCrypt/src/pk/ecc/ecc_get_size.c
	$(TC_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)ecc_import.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomCrypt/src/pk/ecc/ecc_import.c
	$(TC_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)ecc_make_key.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomCrypt/src/pk/ecc/ecc_make_key.c
	$(TC_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)ecc_shared_secret.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomCrypt/src/pk/ecc/ecc_shared_secret.c
	$(TC_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)ecc_sign_hash.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomCrypt/src/pk/ecc/ecc_sign_hash.c
	$(TC_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)ecc_sizes.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomCrypt/src/pk/ecc/ecc_sizes.c
	$(TC_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)ecc_test.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomCrypt/src/pk/ecc/ecc_test.c
	$(TC_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)ecc_verify_hash.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomCrypt/src/pk/ecc/ecc_verify_hash.c
	$(TC_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)ltc_ecc_is_valid_idx.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomCrypt/src/pk/ecc/ltc_ecc_is_valid_idx.c
	$(TC_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)ltc_ecc_map.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomCrypt/src/pk/ecc/ltc_ecc_map.c
	$(TC_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)ltc_ecc_mul2add.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomCrypt/src/pk/ecc/ltc_ecc_mul2add.c
	$(TC_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)ltc_ecc_mulmod.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomCrypt/src/pk/ecc/ltc_ecc_mulmod.c
	$(TC_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)ltc_ecc_mulmod_timing.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomCrypt/src/pk/ecc/ltc_ecc_mulmod_timing.c
	$(TC_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)ltc_ecc_points.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomCrypt/src/pk/ecc/ltc_ecc_points.c
	$(TC_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)ltc_ecc_projective_add_point.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomCrypt/src/pk/ecc/ltc_ecc_projective_add_point.c
	$(TC_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)ltc_ecc_projective_dbl_point.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomCrypt/src/pk/ecc/ltc_ecc_projective_dbl_point.c
	$(TC_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)katja_decrypt_key.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomCrypt/src/pk/katja/katja_decrypt_key.c
	$(TC_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)katja_encrypt_key.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomCrypt/src/pk/katja/katja_encrypt_key.c
	$(TC_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)katja_export.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomCrypt/src/pk/katja/katja_export.c
	$(TC_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)katja_exptmod.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomCrypt/src/pk/katja/katja_exptmod.c
	$(TC_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)katja_free.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomCrypt/src/pk/katja/katja_free.c
	$(TC_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)katja_import.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomCrypt/src/pk/katja/katja_import.c
	$(TC_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)katja_make_key.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomCrypt/src/pk/katja/katja_make_key.c
	$(TC_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)pkcs_1_i2osp.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomCrypt/src/pk/pkcs1/pkcs_1_i2osp.c
	$(TC_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)pkcs_1_mgf1.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomCrypt/src/pk/pkcs1/pkcs_1_mgf1.c
	$(TC_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)pkcs_1_oaep_decode.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomCrypt/src/pk/pkcs1/pkcs_1_oaep_decode.c
	$(TC_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)pkcs_1_oaep_encode.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomCrypt/src/pk/pkcs1/pkcs_1_oaep_encode.c
	$(TC_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)pkcs_1_os2ip.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomCrypt/src/pk/pkcs1/pkcs_1_os2ip.c
	$(TC_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)pkcs_1_pss_decode.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomCrypt/src/pk/pkcs1/pkcs_1_pss_decode.c
	$(TC_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)pkcs_1_pss_encode.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomCrypt/src/pk/pkcs1/pkcs_1_pss_encode.c
	$(TC_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)pkcs_1_v15_es_decode.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomCrypt/src/pk/pkcs1/pkcs_1_v15_es_decode.c
	$(TC_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)pkcs_1_v15_es_encode.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomCrypt/src/pk/pkcs1/pkcs_1_v15_es_encode.c
	$(TC_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)pkcs_1_v15_sa_decode.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomCrypt/src/pk/pkcs1/pkcs_1_v15_sa_decode.c
	$(TC_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)pkcs_1_v15_sa_encode.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomCrypt/src/pk/pkcs1/pkcs_1_v15_sa_encode.c
	$(TC_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)pkcs_1_v1_5_decode.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomCrypt/src/pk/pkcs1/pkcs_1_v1_5_decode.c
	$(TC_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)pkcs_1_v1_5_encode.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomCrypt/src/pk/pkcs1/pkcs_1_v1_5_encode.c
	$(TC_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)rsa_decrypt_key.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomCrypt/src/pk/rsa/rsa_decrypt_key.c
	$(TC_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)rsa_encrypt_key.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomCrypt/src/pk/rsa/rsa_encrypt_key.c
	$(TC_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)rsa_export.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomCrypt/src/pk/rsa/rsa_export.c
	$(TC_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)rsa_exptmod.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomCrypt/src/pk/rsa/rsa_exptmod.c
	$(TC_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)rsa_free.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomCrypt/src/pk/rsa/rsa_free.c
	$(TC_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)rsa_import.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomCrypt/src/pk/rsa/rsa_import.c
	$(TC_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)rsa_make_key.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomCrypt/src/pk/rsa/rsa_make_key.c
	$(TC_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)rsa_sign_hash.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomCrypt/src/pk/rsa/rsa_sign_hash.c
	$(TC_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)rsa_v15_decrypt_key.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomCrypt/src/pk/rsa/rsa_v15_decrypt_key.c
	$(TC_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)rsa_v15_encrypt_key.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomCrypt/src/pk/rsa/rsa_v15_encrypt_key.c
	$(TC_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)rsa_v15_sign_hash.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomCrypt/src/pk/rsa/rsa_v15_sign_hash.c
	$(TC_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)rsa_v15_verify_hash.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomCrypt/src/pk/rsa/rsa_v15_verify_hash.c
	$(TC_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)rsa_verify_hash.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomCrypt/src/pk/rsa/rsa_verify_hash.c
	$(TC_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)fortuna.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomCrypt/src/prngs/fortuna.c
	$(TC_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)rc4.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomCrypt/src/prngs/rc4.c
	$(TC_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)rng_get_bytes.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomCrypt/src/prngs/rng_get_bytes.c
	$(TC_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)rng_make_prng.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomCrypt/src/prngs/rng_make_prng.c
	$(TC_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)sober128.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomCrypt/src/prngs/sober128.c
	$(TC_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)sprng.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomCrypt/src/prngs/sprng.c
	$(TC_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)yarrow.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomCrypt/src/prngs/yarrow.c
	$(TC_CC_CMD) $< $(CCFLAG_OUTPUT) $@

